function rntk = best_result_rntk(x,y,id)
kfold = max(id);
[~,T] = size(x);
L = 1;
paramrntk = struct();
paramrntk.sigmaw = [sqrt(2),ones(1,(L-1))];
paramrntk.sigmau = 1*ones(1,L);
paramrntk.sigmav = 1;
paramrntk.sigmab = 0*ones(1,L);
paramrntk.sigmah = 0;
paramrntk.L = L;
paramrntk.nonlinearity = 1;
acc_best = 0;
sigmaw_iter = [sqrt(2),1.34,1.35,1.36,1.37,1.38,1.39,1.40,1.41,1.42,1.43,1.44,1.45,1.46,1.47,1.48];
sigmab_iter = [0,0.01,0.05,0.1,0.2,0.3,0.4,0.5,0.7,0.9,1,2];
sigmah_iter = [0,0.01,0.1,0.5,1];
Time = 0;
counter = 0;
for k = 1:length(sigmaw_iter)
    for i = 1:length(sigmab_iter)
        for j = 1:length(sigmah_iter)  
            tic
            paramrntk.sigmaw = [sigmaw_iter(k),sigmaw_iter(k)*ones(1,(L-1))];
            paramrntk.sigmab = sigmab_iter(i)*ones(1,L);
            paramrntk.sigmah = sigmah_iter(j);
            kernel_train = cell(kfold,1);
            kernel_test = cell(kfold,1);
            y_train = cell(kfold,1);
            y_test = cell(kfold,1);
            for q = 1:kfold
                id_train = find(id ~= q);
                id_test = find(id == q);
                kernel_train{q} = newgramRNTK(x(id_train,:),x(id_train,:),paramrntk);
                kernel_test{q} = newgramRNTK(x(id_test,:),x(id_train,:),paramrntk);
                y_train{q} = y(id_train);
                y_test{q} = y(id_test);
            end
           
            if  norm(kernel_train{1})/(size(kernel_train{1},1)^2) < 10^10
                [acc_current,svmparam] = give_me_best_acc_svm(kernel_train,kernel_test,y_train,y_test);
                if acc_current > acc_best
                   acc_best = acc_current
                   best_sigma_w = sigmaw_iter(k);
                   best_sigma_b = sigmab_iter(i);
                   best_sigma_h = sigmah_iter(j);
                   svmparam_best = svmparam;
                end
            end
            counter = counter+1;
            Time(counter) = toc;
            sum_time = sum(Time);
            percent_complete = 100*( (k-1)*( length(sigmab_iter)*length(sigmah_iter) ) + (i-1)*length(sigmah_iter) + j )/(length(sigmaw_iter)*length(sigmab_iter)*length(sigmah_iter) );
            remain_time = (100 - percent_complete)*sum_time/percent_complete;
            fprintf(' RNTK : %.2f percent Complete with best kfold accuracy %.2f , Estimatated remaining time: %.2f minutes \n',percent_complete , acc_best , remain_time/60 )      
        end
    end
end
paramrntk.sigmaw = [best_sigma_w,ones(1,(L-1))];
paramrntk.sigmab = best_sigma_b*ones(1,L);
paramrntk.sigmah = best_sigma_h;
rntk = struct();
rntk.param = paramrntk;
rntk.acc_kfold = acc_best;
rntk.svmparam = svmparam_best;
end

